/* SPDX-License-Identifier: GPL-2.0-only */

#include <gpio.h>
#include <mainboard/gpio.h>

/*
 * Pad configuration was generated automatically using intelp2m 2.5-a48e94c74b
 * [*] - allow FSP to configure this pad
 */
static const struct pad_config gpio_table[] = {
	/* ------- GPIO Community 0 ------- */
	/* ------- GPIO Group GPP_A ------- */
	PAD_CFG_NF(GPP_A0, NONE, PLTRST, NF1),		/* RCIN# */
	PAD_CFG_NF(GPP_A1, NONE, PLTRST, NF1),		/* LAD0 */
	PAD_CFG_NF(GPP_A2, NONE, PLTRST, NF1),		/* LAD1 */
	PAD_CFG_NF(GPP_A3, NONE, PLTRST, NF1),		/* LAD2 */
	PAD_CFG_NF(GPP_A4, NONE, PLTRST, NF1),		/* LAD3 */
	PAD_CFG_NF(GPP_A5, NONE, PLTRST, NF1),		/* LFRAME# */
	PAD_CFG_NF(GPP_A6, NONE, PLTRST, NF1),		/* SERIRQ */
	PAD_CFG_NF(GPP_A7, NONE, PLTRST, NF1),		/* PIRQA# */
	PAD_CFG_NF(GPP_A8, NONE, PLTRST, NF1),		/* CLKRUN# */
	PAD_CFG_NF(GPP_A9, NONE, PLTRST, NF1),		/* CLKOUT_LPC0 */
	PAD_CFG_NF(GPP_A10, NONE, PLTRST, NF1),		/* CLKOUT_LPC1 */
	PAD_CFG_NF(GPP_A11, NONE, PLTRST, NF1),		/* PME# */
	PAD_NC(GPP_A12, NONE),
	PAD_CFG_NF(GPP_A13, NONE, DEEP, NF1),		/* SUSWARN#/SUSPWRDNACK */
	PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1),		/* SUS_STAT# */
	PAD_CFG_NF(GPP_A15, NONE, DEEP, NF1),		/* SUSACK# */
	PAD_CFG_NF(GPP_A16, NONE, PLTRST, NF1),		/* CLKOUT_48 */
	PAD_NC(GPP_A17, NONE),
	PAD_NC(GPP_A18, NONE),
	PAD_NC(GPP_A19, NONE),
	PAD_NC(GPP_A20, NONE),
	PAD_NC(GPP_A21, NONE),
	PAD_NC(GPP_A22, NONE),
	PAD_NC(GPP_A23, NONE),

	/* ------- GPIO Group GPP_B ------- */
	PAD_NC(GPP_B0, NONE),
	PAD_CFG_GPO(GPP_B1, 1, PLTRST),
	PAD_NC(GPP_B2, NONE),
	PAD_NC(GPP_B3, NONE),
	PAD_NC(GPP_B4, NONE),
	/* [*] GPP_B5 GPIO/SRCCLKREQ0# */
	/* [*] GPP_B6 GPIO/SRCCLKREQ1# */
	/* [*] GPP_B7 GPIO/SRCCLKREQ2# */
	/* [*] GPP_B8 GPIO/SRCCLKREQ3# */
	/* [*] GPP_B9 GPIO/SRCCLKREQ4# */
	/* [*] GPP_B10 GPIO/SRCCLKREQ5# */
	PAD_NC(GPP_B11, NONE),
	PAD_NC(GPP_B12, NONE),
	PAD_CFG_NF(GPP_B13, NONE, DEEP, NF1),		/* PLTRST# */
	PAD_CFG_NF(GPP_B14, DN_20K, PLTRST, NF1),	/* SPKR */
	PAD_NC(GPP_B15, NONE),
	PAD_NC(GPP_B16, NONE),
	PAD_NC(GPP_B17, NONE),
	PAD_CFG_GPO(GPP_B18, 0, PLTRST),
	PAD_NC(GPP_B19, NONE),
	PAD_NC(GPP_B20, NONE),
	PAD_NC(GPP_B21, NONE),
	PAD_CFG_GPO(GPP_B22, 0, PLTRST),
	PAD_CFG_GPO(GPP_B23, 0, PLTRST),
	PAD_CFG_NF(GSPI0_CLK_LOOPBK, NONE, DEEP, NF1),	/* GSPI0_CLK_LOOPBK */

	/* ------- GPIO Community 1 ------- */
	/* ------- GPIO Group GPP_C ------- */
	PAD_CFG_NF(GPP_C0, NONE, DEEP, NF1),		/* SMBCLK */
	PAD_CFG_NF(GPP_C1, NONE, DEEP, NF1),		/* SMBDATA */
	PAD_CFG_GPO(GPP_C2, 1, PLTRST),
	PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1),		/* SML0CLK */
	PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1),		/* SML0DATA */
	PAD_CFG_GPO(GPP_C5, 0, PLTRST),
	PAD_CFG_NF(GPP_C6, NONE, DEEP, NF1),		/* SML1CLK */
	PAD_CFG_NF(GPP_C7, NONE, DEEP, NF1),		/* SML1DATA */
	PAD_NC(GPP_C8, NONE),
	PAD_NC(GPP_C9, NONE),
	PAD_NC(GPP_C10, NONE),
	PAD_NC(GPP_C11, NONE),
	PAD_NC(GPP_C12, NONE),
	PAD_NC(GPP_C13, NONE),
	PAD_NC(GPP_C14, NONE),
	PAD_NC(GPP_C15, NONE),
	PAD_NC(GPP_C16, NONE),
	PAD_NC(GPP_C17, NONE),
	PAD_NC(GPP_C18, NONE),
	PAD_NC(GPP_C19, NONE),
	PAD_NC(GPP_C20, NONE),
	PAD_NC(GPP_C21, NONE),
	PAD_NC(GPP_C22, NONE),
	PAD_NC(GPP_C23, NONE),

	/* ------- GPIO Group GPP_D ------- */
	PAD_NC(GPP_D0, NONE),
	PAD_NC(GPP_D1, NONE),
	PAD_NC(GPP_D2, NONE),
	PAD_NC(GPP_D3, NONE),
	PAD_NC(GPP_D4, NONE),
	PAD_CFG_NF(GPP_D5, NONE, PLTRST, NF3),		/* CNV_RF_RESET# */
	PAD_CFG_NF(GPP_D6, NONE, PLTRST, NF3),		/* MODEM_CLKREQ */
	PAD_CFG_NF(GPP_D7, NONE, PLTRST, NF1),		/* I2S2_RXD */
	PAD_CFG_NF(GPP_D8, NONE, PLTRST, NF1),		/* I2S2_SCLK */
	PAD_NC(GPP_D9, NONE),
	PAD_NC(GPP_D10, NONE),
	PAD_NC(GPP_D11, NONE),
	PAD_NC(GPP_D12, NONE),
	PAD_NC(GPP_D13, NONE),
	PAD_NC(GPP_D14, NONE),
	PAD_CFG_NF(GPP_D15, NONE, PLTRST, NF4),		/* CNV_WFEN */
	PAD_CFG_NF(GPP_D16, NONE, PLTRST, NF4),		/* CNV_WCEN */
	PAD_CFG_NF(GPP_D17, NONE, PLTRST, NF1),		/* DMIC_CLK1 */
	PAD_CFG_NF(GPP_D18, NONE, PLTRST, NF1),		/* DMIC_DATA1 */
	PAD_CFG_NF(GPP_D19, NONE, PLTRST, NF1),		/* DMIC_CLK0 */
	PAD_CFG_NF(GPP_D20, NONE, PLTRST, NF1),		/* DMIC_DATA0 */
	PAD_NC(GPP_D21, NONE),
	PAD_NC(GPP_D22, NONE),
	PAD_NC(GPP_D23, NONE),

	/* ------- GPIO Group GPP_G ------- */
	PAD_CFG_GPI_TRIG_OWN(GPP_G0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPO(GPP_G1, 1, DEEP),
	PAD_CFG_GPO(GPP_G2, 1, DEEP),
	PAD_CFG_GPO(GPP_G3, 1, DEEP),
	PAD_CFG_GPO(GPP_G4, 1, DEEP),
	PAD_CFG_GPO(GPP_G5, 1, DEEP),
	PAD_NC(GPP_G6, NONE),
	PAD_NC(GPP_G7, NONE),

	/* ------- GPIO Group AZA ------- */
	PAD_CFG_NF(HDA_BCLK, NATIVE, DEEP, NF1),	/* HDA_BCLK */
	PAD_CFG_NF(HDA_RST_B, NATIVE, DEEP, NF1),	/* HDA_RST# */
	PAD_CFG_NF(HDA_SYNC, NATIVE, DEEP, NF1),	/* HDA_SYNC */
	PAD_CFG_NF(HDA_SDO, NATIVE, DEEP, NF1),		/* HDA_SDO */
	PAD_CFG_NF(HDA_SDI0, NATIVE, DEEP, NF1),	/* HDA_SDI0 */
	PAD_CFG_NF(HDA_SDI1, NATIVE, DEEP, NF1),	/* HDA_SDI1 */
	PAD_CFG_NF(I2S1_SFRM, NATIVE, DEEP, NF1),	/* I2S1_SFRM */
	PAD_CFG_NF(I2S1_TXD, NATIVE, DEEP, NF1),	/* I2S1_TXD */

	/* ------- GPIO Group VGPIO_0 ------- */
	PAD_CFG_GPO(CNV_BTEN, 0, DEEP),
	PAD_CFG_GPIO_BIDIRECT(CNV_GNEN, 0, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_GPIO_BIDIRECT(CNV_WFEN, 0, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_GPIO_BIDIRECT(CNV_WCEN, 1, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_GPI_TRIG_OWN(vCNV_GNSS_HOST_WAKE_B, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPIO_BIDIRECT(vSD3_CD_B, 0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPIO_BIDIRECT(CNV_BT_HOST_WAKE_B, 0, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPIO_BIDIRECT(CNV_BT_IF_SELECT, 1, NONE, DEEP, LEVEL, ACPI),
	PAD_CFG_NF(vCNV_BT_UART_TXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_BT_UART_RXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_BT_UART_CTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_BT_UART_RTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_MFUART1_TXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_MFUART1_RXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_MFUART1_CTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_MFUART1_RTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_GNSS_UART_TXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_GNSS_UART_RXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_GNSS_UART_CTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_GNSS_UART_RTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vUART0_TXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vUART0_RXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vUART0_CTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vUART0_RTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART0_TXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART0_RXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART0_CTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART0_RTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART1_TXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART1_RXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART1_CTS_B, NONE, DEEP, NF1),
	PAD_CFG_NF(vISH_UART1_RTS_B, NONE, DEEP, NF1),

	/* ------- GPIO Group VGPIO_1 ------- */
	PAD_CFG_NF(vCNV_BT_I2S_BCLK, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_BT_I2S_WS_SYNC, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_BT_I2S_SDO, NONE, DEEP, NF1),
	PAD_CFG_NF(vCNV_BT_I2S_SDI, NONE, DEEP, NF1),
	PAD_CFG_NF(vSSP2_SCLK, NONE, DEEP, NF1),
	PAD_CFG_NF(vSSP2_SFRM, NONE, DEEP, NF1),
	PAD_CFG_NF(vSSP2_TXD, NONE, DEEP, NF1),
	PAD_CFG_NF(vSSP2_RXD, NONE, DEEP, NF1),

	/* ------- GPIO Community 2 ------- */
	/* ------- GPIO Group GPD ------- */
	PAD_CFG_NF(GPD0, NONE, RSMRST, NF1),		/* BATLOW# */
	PAD_CFG_NF(GPD1, NONE, RSMRST, NF1),		/* ACPRESENT */
	PAD_CFG_NF(GPD2, NONE, RSMRST, NF1),		/* LAN_WAKE# */
	PAD_CFG_NF(GPD3, NONE, RSMRST, NF1),		/* PRWBTN# */
	PAD_CFG_NF(GPD4, NONE, RSMRST, NF1),		/* SLP_S3# */
	PAD_CFG_NF(GPD5, NONE, RSMRST, NF1),		/* SLP_S4# */
	PAD_CFG_NF(GPD6, NONE, RSMRST, NF1),		/* SLP_A# */
	PAD_CFG_GPO(GPD7, 1, PLTRST),
	PAD_CFG_NF(GPD8, NONE, RSMRST, NF1),		/* SUSCLK */
	PAD_CFG_NF(GPD9, NONE, RSMRST, NF1),		/* SLP_WLAN# */
	PAD_CFG_NF(GPD10, NONE, RSMRST, NF1),		/* SLP_S5# */
	PAD_CFG_NF(GPD11, NONE, RSMRST, NF1),		/* LANPHYPC */
	PAD_CFG_NF(SLP_LAN_B, NONE, RSMRST, NF1),	/* SLP_LAN# */
	PAD_CFG_NF(SLP_SUS_B, NONE, RSMRST, NF1),	/* SLP_SUS# */
	PAD_CFG_NF(WAKE_B, NONE, RSMRST, NF1),		/* WAKE# */
	PAD_CFG_NF(DRAM_RESET_B, NONE, RSMRST, NF1),	/* DRAM_RESET# */

	/* ------- GPIO Community 3 ------- */
	/* ------- GPIO Group GPP_K ------- */
	PAD_CFG_GPO(GPP_K0, 0, PLTRST),
	PAD_CFG_GPO(GPP_K1, 0, PLTRST),
	PAD_CFG_GPO(GPP_K2, 0, PLTRST),
	PAD_CFG_GPO(GPP_K3, 0, PLTRST),
	PAD_CFG_GPO(GPP_K4, 1, PLTRST),
	PAD_CFG_GPO(GPP_K5, 1, PLTRST),
	PAD_CFG_GPO(GPP_K6, 0, RSMRST),
	PAD_CFG_GPO(GPP_K7, 0, RSMRST),
	PAD_CFG_GPO(GPP_K8, 0, PLTRST),
	PAD_CFG_GPO(GPP_K9, 0, PLTRST),
	PAD_CFG_GPO(GPP_K10, 0, PLTRST),
	PAD_CFG_GPO(GPP_K11, 0, PLTRST),
	PAD_CFG_GPI_SCI(GPP_K12, NONE, PLTRST, EDGE_SINGLE, INVERT),
	PAD_NC(GPP_K13, NONE),
	PAD_CFG_GPO(GPP_K14, 1, DEEP),
	PAD_CFG_GPI_TRIG_OWN(GPP_K15, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPO(GPP_K16, 0, PLTRST),
	PAD_CFG_GPI_TRIG_OWN(GPP_K17, NONE, PLTRST, OFF, ACPI),
	PAD_NC(GPP_K18, NONE),
	PAD_NC(GPP_K19, NONE),
	PAD_CFG_GPI_TRIG_OWN(GPP_K20, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K21, NONE, DEEP, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K22, NONE, PLTRST, OFF, ACPI),
	PAD_CFG_GPI_TRIG_OWN(GPP_K23, NONE, PLTRST, OFF, ACPI),

	/* ------- GPIO Group GPP_H ------- */
	/* [*] GPP_H0 GPIO/SRCCLKREQ6# */
	/* [*] GPP_H1 GPIO/SRCCLKREQ7# */
	PAD_NC(GPP_H2, NONE),
	PAD_NC(GPP_H3, NONE),
	PAD_NC(GPP_H4, NONE),
	PAD_NC(GPP_H5, NONE),
	PAD_NC(GPP_H6, NONE),
	PAD_NC(GPP_H7, NONE),
	PAD_NC(GPP_H8, NONE),
	PAD_NC(GPP_H9, NONE),
	PAD_NC(GPP_H10, NONE),
	PAD_NC(GPP_H11, NONE),
	PAD_CFG_GPO(GPP_H12, 0, PLTRST),
	PAD_NC(GPP_H13, NONE),
	PAD_NC(GPP_H14, NONE),
	PAD_NC(GPP_H15, NONE),
	PAD_NC(GPP_H16, NONE),
	PAD_NC(GPP_H17, NONE),
	PAD_NC(GPP_H18, NONE),
	PAD_NC(GPP_H19, NONE),
	PAD_NC(GPP_H20, NONE),
	PAD_NC(GPP_H21, NONE),
	PAD_NC(GPP_H22, NONE),
	PAD_NC(GPP_H23, NONE),

	/* ------- GPIO Group GPP_E ------- */
	PAD_CFG_NF(GPP_E0, NONE, PLTRST, NF1),		/* SATAXPCIE0 */
	PAD_CFG_NF(GPP_E1, NONE, PLTRST, NF1),		/* SATAXPCIE1 */
	PAD_CFG_NF(GPP_E2, NONE, PLTRST, NF1),		/* SATAXPCIE2 */
	PAD_CFG_GPO(GPP_E3, 1, PLTRST),
	PAD_NC(GPP_E4, NONE),
	PAD_CFG_GPI_SMI(GPP_E5, NONE, PLTRST, EDGE_SINGLE, INVERT),
	PAD_CFG_GPI_SMI(GPP_E6, NONE, PLTRST, EDGE_SINGLE, INVERT),
	PAD_NC(GPP_E7, NONE),
	PAD_CFG_NF(GPP_E8, UP_5K, PLTRST, NF1),		/* SATALED# */
	PAD_NC(GPP_E9, NONE),
	PAD_NC(GPP_E10, NONE),
	PAD_NC(GPP_E11, NONE),
	PAD_NC(GPP_E12, NONE),

	/* ------- GPIO Group GPP_F ------- */
	PAD_CFG_GPO(GPP_F0, 0, PLTRST),
	PAD_CFG_NF(GPP_F1, UP_5K, PLTRST, NF1),		/* SATAXPCIE4 */
	PAD_CFG_GPO(GPP_F2, 0, PLTRST),
	PAD_CFG_GPO(GPP_F3, 0, PLTRST),
	PAD_CFG_GPO(GPP_F4, 0, PLTRST),
	PAD_NC(GPP_F5, NONE),
	PAD_NC(GPP_F6, NONE),
	PAD_NC(GPP_F7, NONE),
	PAD_CFG_NF(GPP_F8, NONE, PLTRST, NF1),		/* SATA_DEVSLP6 */
	PAD_NC(GPP_F9, NONE),
	PAD_NC(GPP_F10, NONE),
	PAD_NC(GPP_F11, NONE),
	PAD_NC(GPP_F12, NONE),
	PAD_NC(GPP_F13, NONE),
	PAD_CFG_NF(GPP_F14, NONE, PLTRST, NF2),		/* PS_ON# */
	PAD_NC(GPP_F15, NONE),
	PAD_NC(GPP_F16, NONE),
	PAD_NC(GPP_F17, NONE),
	PAD_NC(GPP_F18, NONE),
	PAD_CFG_NF(GPP_F19, NONE, PLTRST, NF1),		/* eDP_VDDEN */
	PAD_CFG_NF(GPP_F20, NONE, PLTRST, NF1),		/* eDP_BKLTEN */
	PAD_CFG_NF(GPP_F21, NONE, PLTRST, NF1),		/* eDP_BKLTCTL */
	PAD_NC(GPP_F22, NONE),
	PAD_CFG_GPO(GPP_F23, 0, PLTRST),

	/* ------- GPIO Group SPI ------- */
	PAD_CFG_NF(SPI0_IO_2, NATIVE, DEEP, NF1),	/* SPI0_IO_2 */
	PAD_CFG_NF(SPI0_IO_3, NATIVE, DEEP, NF1),	/* SPI0_IO_3 */
	PAD_CFG_NF(SPI0_MISO, NATIVE, DEEP, NF1),	/* SPI0_MISO */
	PAD_CFG_NF(SPI0_MOSI, NATIVE, DEEP, NF1),	/* SPI0_MOSI */
	PAD_CFG_NF(SPI0_CS2_B, NATIVE, DEEP, NF1),	/* SPI0_CS2# */
	PAD_CFG_NF(SPI0_CS0_B, NATIVE, DEEP, NF1),	/* SPI0_CS0# */
	PAD_CFG_NF(SPI0_CS1_B, NATIVE, DEEP, NF1),	/* SPI0_CS1# */
	PAD_CFG_NF(SPI0_CLK, NATIVE, DEEP, NF1),	/* SPI0_CLK */
	PAD_CFG_NF(SPI0_CLK_LOOPBK, NONE, DEEP, NF1),	/* SPI0_CLK_LOOPBK */

	/* ------- GPIO Community 4 ------- */
	/* ------- GPIO Group CPU ------- */
	PAD_CFG_NF(HDACPU_SDI, NATIVE, DEEP, NF1),	/* HDACPU_SDI */
	PAD_CFG_NF(HDACPU_SDO, NATIVE, DEEP, NF1),	/* HDACPU_SDO */
	PAD_CFG_NF(HDACPU_SCLK, NATIVE, DEEP, NF1),	/* HDACPU_SCLK */
	PAD_CFG_NF(PM_SYNC, NONE, DEEP, NF1),		/* PM_SYNC */
	PAD_CFG_NF(PECI_IO, NONE, DEEP, NF1),		/* PECI_IO */
	PAD_CFG_NF(CPUPWRGD, NONE, DEEP, NF1),		/* CPUPWRG# */
	PAD_CFG_NF(THRMTRIP_B, NONE, DEEP, NF1),	/* THRMTRIP# */
	PAD_CFG_NF(PLTRST_CPU_B, NONE, DEEP, NF1),	/* PLTRST_CPU# */
	PAD_CFG_NF(PM_DOWN, NONE, DEEP, NF1),		/* PM_DOWN */
	PAD_CFG_NF(TRIGGER_IN, DN_20K, DEEP, NF1),	/* TRIGGER_IN */
	PAD_CFG_NF(TRIGGER_OUT, DN_20K, DEEP, NF1),	/* TRIGGER_OUT */

	/* ------- GPIO Group JTAG ------- */
	PAD_CFG_NF(PCH_TDO, NATIVE, DEEP, NF1),		/* PCH_TDO */
	PAD_CFG_NF(PCH_JTAGX, NATIVE, DEEP, NF1),	/* PCH_JTAGX */
	PAD_CFG_NF(PROC_PRDY_B, NATIVE, DEEP, NF1),	/* PROC_RDY# */
	PAD_CFG_NF(PROC_PREQ_B, NATIVE, DEEP, NF1),	/* PROC_REQ# */
	PAD_CFG_NF(CPU_TRST_B, NATIVE, DEEP, NF1),	/* CPU_TRST# */
	PAD_CFG_NF(PCH_TDI, NATIVE, DEEP, NF1),		/* PCH_TDI */
	PAD_CFG_NF(PCH_TMS, NATIVE, DEEP, NF1),		/* PCH_TMS */
	PAD_CFG_NF(PCH_TCK, NATIVE, DEEP, NF1),		/* PCH_TCK */
	PAD_CFG_NF(ITP_PMODE, NATIVE, DEEP, NF1),	/* ITP_PMODE */

	/* ------- GPIO Group GPP_I ------- */
	PAD_CFG_NF(GPP_I0, NONE, PLTRST, NF1),		/* DDPB_HPD0 */
	PAD_CFG_NF(GPP_I1, NONE, PLTRST, NF1),		/* DDPB_HPD1 */
	PAD_CFG_NF(GPP_I2, NONE, PLTRST, NF1),		/* DDPB_HPD2 */
	PAD_NC(GPP_I3, NONE),
	PAD_CFG_NF(GPP_I4, NONE, PLTRST, NF1),		/* EDP_HPD */
	PAD_CFG_NF(GPP_I5, NONE, PLTRST, NF1),		/* DDPB_CTRLCLK */
	PAD_CFG_NF(GPP_I6, NONE, PLTRST, NF1),		/* DDPB_CTRLDATA */
	PAD_CFG_NF(GPP_I7, NONE, PLTRST, NF1),		/* DDPC_CTRLCLK */
	PAD_CFG_NF(GPP_I8, NONE, PLTRST, NF1),		/* DDPC_CTRLDATA */
	PAD_CFG_NF(GPP_I9, NONE, PLTRST, NF1),		/* DDPD_CTRLCLK */
	PAD_CFG_NF(GPP_I10, NONE, PLTRST, NF1),		/* DDPD_CTRLDATA */
	PAD_NC(GPP_I11, NONE),
	PAD_CFG_GPO(GPP_I12, 0, PLTRST),
	PAD_NC(GPP_I13, NONE),
	PAD_CFG_GPO(GPP_I14, 1, PLTRST),
	PAD_CFG_NF(SYS_PWROK, NONE, DEEP, NF1),		/* SYS_PWROK */
	PAD_CFG_NF(SYS_RESET_B, NONE, DEEP, NF1),	/* SYS_RESET# */
	PAD_CFG_NF(CL_RST_B, NONE, DEEP, NF1),		/* CL_RST# */

	/* ------- GPIO Group GPP_J ------- */
	PAD_CFG_NF(GPP_J0, NONE, PLTRST, NF1),		/* CNV_PA_BLANKING */
	PAD_CFG_NF(GPP_J1, NONE, PLTRST, NF2),		/* CPU_C10_GATE# */
	PAD_NC(GPP_J2, NONE),
	PAD_NC(GPP_J3, NONE),
	PAD_CFG_NF(GPP_J4, NONE, PLTRST, NF1),		/* CNV_BRI_DT */
	PAD_CFG_NF(GPP_J5, NONE, PLTRST, NF1),		/* CNV_BRI_RSP */
	PAD_CFG_NF(GPP_J6, NONE, PLTRST, NF1),		/* CNV_RGI_DT */
	PAD_CFG_NF(GPP_J7, NONE, PLTRST, NF1),		/* CNV_RGI_RSP */
	PAD_CFG_NF(GPP_J8, NONE, PLTRST, NF1),		/* CNV_MFUART2_RXD */
	PAD_CFG_NF(GPP_J9, NONE, PLTRST, NF1),		/* CNV_MFUART2_TXD */
	PAD_NC(GPP_J10, NONE),
	PAD_NC(GPP_J11, NONE),
};

void mainboard_configure_gpios(void)
{
	gpio_configure_pads(gpio_table, ARRAY_SIZE(gpio_table));
}
