# SPDX-FileCopyrightText: Peter Pentchev <roam@ringlet.net>
# SPDX-License-Identifier: GPL-2.0-or-later
"""Unit tests for the `debsigs-installer` tool."""

from __future__ import annotations

import typing

import pytest

from .util import test_cfg  # noqa: F401  # pytest fixture


if typing.TYPE_CHECKING:
    from . import util


def test_installer(test_cfg: util.ConfigAggr) -> None:  # noqa: F811  # pytest fixture
    """Sign files, copy them over to an archive tree."""
    if not test_cfg.has_feature("tool-installer", "1"):
        pytest.skip("No `debsigs-installer` at feature version 1 support")

    raise NotImplementedError
