#!/usr/bin/python3
"""
CMake fragment handling for Fortran : tests

Copyright (C) 2025 Alastair McKinstry <mckinstry@debian.org>
Released under the GPL-3 Gnu Public License.
"""

from click.testing import CliRunner
from dhfortran.cmake import dh_fortran_cmake
import dhfortran.debhelper as dh
import dhfortran.tests.helpers as helpers


# def test_rename(set_env):
#     assert (
#         dh.clone_and_rename("hipsparse-targets.cmake", vendor="gnu")
#         == "hipsparse-targets-gnu.cmake"
#     )
#     assert (
#         dh.clone_and_rename("hipsparse-targets.cmake", flavor="gfortran")
#         == "hipsparse-targets-gfortran.cmake"
#     )


def test_dh_fortran_cmake_trivial():
    runner = CliRunner()
    result = runner.invoke(dh_fortran_cmake, [])
    assert result.exit_code == 0
    assert result.output == ""


def test_dh_fortran_cmake_with_fc():
    runner = CliRunner()
    result = runner.invoke(dh_fortran_cmake, ["--fc", "gfortran-15"])
    assert result.exit_code == 0
    # assert result.output == 'Hello Peter!\n'


def test_dh_fortran_cmake_trivial_verbose():
    runner = CliRunner()
    result = runner.invoke(dh_fortran_cmake, ["--verbose"])
    assert result.exit_code == 0
    # assert result.output.startswith("dh_fortran_cmake called with")


# TODO Need better error output
def test_dh_fortran_cmake_with_garbage_fc():
    runner = CliRunner()
    result = runner.invoke(dh_fortran_cmake, ["--fc", "garbage"])
    assert result.exit_code == 2


#    assert (
#        result.output
#        == "Usage: wrapper [OPTIONS]\nTry 'wrapper --help' for help.\n\nError: garbage is not a valid compiler flavor\n"
#    )


def test_dh_fortran_cmake_list_of_files():
    runner = CliRunner()
    result = runner.invoke(dh_fortran_cmake, ["--verbose", "filea", "fileb"])
    assert result.exit_code == 0


#    assert result.output.startswith("dh_fortran_cmake called with")


if __name__ == "__main__":
    import pytest

    pytest.main()
