//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armeventgrid

import "encoding/json"

func unmarshalAdvancedFilterClassification(rawMsg json.RawMessage) (AdvancedFilterClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b AdvancedFilterClassification
	switch m["operatorType"] {
	case string(AdvancedFilterOperatorTypeBoolEquals):
		b = &BoolEqualsAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeIsNotNull):
		b = &IsNotNullAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeIsNullOrUndefined):
		b = &IsNullOrUndefinedAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberGreaterThan):
		b = &NumberGreaterThanAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberGreaterThanOrEquals):
		b = &NumberGreaterThanOrEqualsAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberIn):
		b = &NumberInAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberInRange):
		b = &NumberInRangeAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberLessThan):
		b = &NumberLessThanAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberLessThanOrEquals):
		b = &NumberLessThanOrEqualsAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberNotIn):
		b = &NumberNotInAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeNumberNotInRange):
		b = &NumberNotInRangeAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringBeginsWith):
		b = &StringBeginsWithAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringContains):
		b = &StringContainsAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringEndsWith):
		b = &StringEndsWithAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringIn):
		b = &StringInAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringNotBeginsWith):
		b = &StringNotBeginsWithAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringNotContains):
		b = &StringNotContainsAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringNotEndsWith):
		b = &StringNotEndsWithAdvancedFilter{}
	case string(AdvancedFilterOperatorTypeStringNotIn):
		b = &StringNotInAdvancedFilter{}
	default:
		b = &AdvancedFilter{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalAdvancedFilterClassificationArray(rawMsg json.RawMessage) ([]AdvancedFilterClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]AdvancedFilterClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalAdvancedFilterClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalDeadLetterDestinationClassification(rawMsg json.RawMessage) (DeadLetterDestinationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DeadLetterDestinationClassification
	switch m["endpointType"] {
	case string(DeadLetterEndPointTypeStorageBlob):
		b = &StorageBlobDeadLetterDestination{}
	default:
		b = &DeadLetterDestination{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalDeliveryAttributeMappingClassification(rawMsg json.RawMessage) (DeliveryAttributeMappingClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b DeliveryAttributeMappingClassification
	switch m["type"] {
	case string(DeliveryAttributeMappingTypeDynamic):
		b = &DynamicDeliveryAttributeMapping{}
	case string(DeliveryAttributeMappingTypeStatic):
		b = &StaticDeliveryAttributeMapping{}
	default:
		b = &DeliveryAttributeMapping{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalDeliveryAttributeMappingClassificationArray(rawMsg json.RawMessage) ([]DeliveryAttributeMappingClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var rawMessages []json.RawMessage
	if err := json.Unmarshal(rawMsg, &rawMessages); err != nil {
		return nil, err
	}
	fArray := make([]DeliveryAttributeMappingClassification, len(rawMessages))
	for index, rawMessage := range rawMessages {
		f, err := unmarshalDeliveryAttributeMappingClassification(rawMessage)
		if err != nil {
			return nil, err
		}
		fArray[index] = f
	}
	return fArray, nil
}

func unmarshalEventSubscriptionDestinationClassification(rawMsg json.RawMessage) (EventSubscriptionDestinationClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b EventSubscriptionDestinationClassification
	switch m["endpointType"] {
	case string(EndpointTypeAzureFunction):
		b = &AzureFunctionEventSubscriptionDestination{}
	case string(EndpointTypeEventHub):
		b = &EventHubEventSubscriptionDestination{}
	case string(EndpointTypeHybridConnection):
		b = &HybridConnectionEventSubscriptionDestination{}
	case string(EndpointTypeServiceBusQueue):
		b = &ServiceBusQueueEventSubscriptionDestination{}
	case string(EndpointTypeServiceBusTopic):
		b = &ServiceBusTopicEventSubscriptionDestination{}
	case string(EndpointTypeStorageQueue):
		b = &StorageQueueEventSubscriptionDestination{}
	case string(EndpointTypeWebHook):
		b = &WebHookEventSubscriptionDestination{}
	default:
		b = &EventSubscriptionDestination{}
	}
	return b, json.Unmarshal(rawMsg, b)
}

func unmarshalInputSchemaMappingClassification(rawMsg json.RawMessage) (InputSchemaMappingClassification, error) {
	if rawMsg == nil {
		return nil, nil
	}
	var m map[string]interface{}
	if err := json.Unmarshal(rawMsg, &m); err != nil {
		return nil, err
	}
	var b InputSchemaMappingClassification
	switch m["inputSchemaMappingType"] {
	case string(InputSchemaMappingTypeJSON):
		b = &JSONInputSchemaMapping{}
	default:
		b = &InputSchemaMapping{}
	}
	return b, json.Unmarshal(rawMsg, b)
}
