#pragma once
/*
 *  $Id: gwygraphcurvemodel.h 28799 2025-11-05 11:47:53Z yeti-dn $
 *  Copyright (C) 2004-2024 David Necas (Yeti), Petr Klapetek.
 *  E-mail: yeti@gwyddion.net, klapetek@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWYUI_GRAPH_CURVE_MODEL_H__
#define __GWYUI_GRAPH_CURVE_MODEL_H__

#include <libgwyddion/rgba.h>
#include <libgwyddion/line.h>

G_BEGIN_DECLS

typedef enum {
    GWY_GRAPH_CURVE_HIDDEN      = 0,
    GWY_GRAPH_CURVE_POINTS      = 1,
    GWY_GRAPH_CURVE_LINE        = 2,
    GWY_GRAPH_CURVE_LINE_POINTS = 3
} GwyGraphCurveType;

typedef enum {
    GWY_GRAPH_POINT_SQUARE                = 0,
    GWY_GRAPH_POINT_CROSS                 = 1,
    GWY_GRAPH_POINT_CIRCLE                = 2,
    GWY_GRAPH_POINT_STAR                  = 3,
    GWY_GRAPH_POINT_TIMES                 = 4,
    GWY_GRAPH_POINT_TRIANGLE_UP           = 5,
    GWY_GRAPH_POINT_TRIANGLE_DOWN         = 6,
    GWY_GRAPH_POINT_DIAMOND               = 7,
    GWY_GRAPH_POINT_FILLED_SQUARE         = 8,
    GWY_GRAPH_POINT_DISC                  = 9,
    GWY_GRAPH_POINT_FILLED_CIRCLE         = GWY_GRAPH_POINT_DISC,
    GWY_GRAPH_POINT_FILLED_TRIANGLE_UP    = 10,
    GWY_GRAPH_POINT_FILLED_TRIANGLE_DOWN  = 11,
    GWY_GRAPH_POINT_FILLED_DIAMOND        = 12,
    GWY_GRAPH_POINT_TRIANGLE_LEFT         = 13,
    GWY_GRAPH_POINT_FILLED_TRIANGLE_LEFT  = 14,
    GWY_GRAPH_POINT_TRIANGLE_RIGHT        = 15,
    GWY_GRAPH_POINT_FILLED_TRIANGLE_RIGHT = 16,
    GWY_GRAPH_POINT_ASTERISK              = 17
} GwyGraphPointType;

typedef enum {
    GWY_GRAPH_LINE_SOLID       = 0,
    GWY_GRAPH_LINE_DASH        = 1,
    GWY_GRAPH_LINE_DASH_SPARSE = 2,
    GWY_GRAPH_LINE_DASH_DENSE  = 3,
    GWY_GRAPH_LINE_DOT         = 4,
    GWY_GRAPH_LINE_DOT_SPARSE  = 5,
    GWY_GRAPH_LINE_DASH_DOT    = 6,
} GwyGraphLineStyle;

const GwyEnum* gwy_graph_curve_type_get_enum(void) G_GNUC_CONST;

#define GWY_TYPE_GRAPH_CURVE_MODEL            (gwy_graph_curve_model_get_type())
#define GWY_GRAPH_CURVE_MODEL(obj)            (G_TYPE_CHECK_INSTANCE_CAST((obj), GWY_TYPE_GRAPH_CURVE_MODEL, GwyGraphCurveModel))
#define GWY_GRAPH_CURVE_MODEL_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST((klass), GWY_TYPE_GRAPH_CURVE_MODEL, GwyGraphCurveModelClass))
#define GWY_IS_GRAPH_CURVE_MODEL(obj)         (G_TYPE_CHECK_INSTANCE_TYPE((obj), GWY_TYPE_GRAPH_CURVE_MODEL))
#define GWY_IS_GRAPH_CURVE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE((klass), GWY_TYPE_GRAPH_CURVE_MODEL))
#define GWY_GRAPH_CURVE_MODEL_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS((obj), GWY_TYPE_GRAPH_CURVE_MODEL, GwyGraphCurveModelClass))

typedef struct _GwyGraphCurveModel        GwyGraphCurveModel;
typedef struct _GwyGraphCurveModelClass   GwyGraphCurveModelClass;
typedef struct _GwyGraphCurveModelPrivate GwyGraphCurveModelPrivate;

struct _GwyGraphCurveModel {
    GObject parent_instance;
    GwyGraphCurveModelPrivate *priv;
};

struct _GwyGraphCurveModelClass {
    GObjectClass parent_class;

    void (*data_changed)(GwyGraphCurveModel *model);

    void (*reserved1)(void);
    void (*reserved2)(void);
    void (*reserved3)(void);
};

GType               gwy_graph_curve_model_get_type            (void)                            G_GNUC_CONST;
GwyGraphCurveModel* gwy_graph_curve_model_new                 (void);
GwyGraphCurveModel* gwy_graph_curve_model_new_alike           (GwyGraphCurveModel *gcmodel);
void                gwy_graph_curve_model_set_data            (GwyGraphCurveModel *gcmodel,
                                                               const gdouble *xdata,
                                                               const gdouble *ydata,
                                                               gint n);
void                gwy_graph_curve_model_set_data_interleaved(GwyGraphCurveModel *gcmodel,
                                                               const gdouble *xydata,
                                                               gint n);
void                gwy_graph_curve_model_set_data_from_line  (GwyGraphCurveModel *gcmodel,
                                                               GwyLine *dline,
                                                               gint from_index,
                                                               gint to_index);
GwyGraphCurveModel* gwy_graph_curve_model_copy                (GwyGraphCurveModel *gcmodel);
void                gwy_graph_curve_model_assign              (GwyGraphCurveModel *destination,
                                                               GwyGraphCurveModel *source);
void                gwy_graph_curve_model_enforce_order       (GwyGraphCurveModel *gcmodel);
gboolean            gwy_graph_curve_model_is_ordered          (GwyGraphCurveModel *gcmodel);
const gdouble*      gwy_graph_curve_model_get_xdata           (GwyGraphCurveModel *gcmodel);
const gdouble*      gwy_graph_curve_model_get_ydata           (GwyGraphCurveModel *gcmodel);
gint                gwy_graph_curve_model_get_ndata           (GwyGraphCurveModel *gcmodel);
gboolean            gwy_graph_curve_model_get_x_range         (GwyGraphCurveModel *gcmodel,
                                                               gdouble *x_min,
                                                               gdouble *x_max);
gboolean            gwy_graph_curve_model_get_y_range         (GwyGraphCurveModel *gcmodel,
                                                               gdouble *y_min,
                                                               gdouble *y_max);
gboolean            gwy_graph_curve_model_get_ranges          (GwyGraphCurveModel *gcmodel,
                                                               gboolean x_logscale,
                                                               gboolean y_logscale,
                                                               gdouble *x_min,
                                                               gdouble *x_max,
                                                               gdouble *y_min,
                                                               gdouble *y_max);
void                gwy_graph_curve_model_get_color           (GwyGraphCurveModel *gcmodel,
                                                               GwyRGBA *color);
const gchar*        gwy_graph_curve_model_get_description     (GwyGraphCurveModel *gcmodel);

const GwyRGBA*      gwy_graph_get_preset_color                  (guint i)                         G_GNUC_CONST;
guint               gwy_graph_get_n_preset_colors               (void)                            G_GNUC_CONST;

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
