; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux \
; RUN:   --ppc-asm-full-reg-names -mcpu=pwr7 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-aix \
; RUN:   --ppc-asm-full-reg-names -mcpu=pwr7 < %s | FileCheck %s
; RUN: llc -verify-machineinstrs -mtriple=powerpc-unknown-aix \
; RUN:   --ppc-asm-full-reg-names -mcpu=pwr7 < %s | FileCheck %s --check-prefix=CHECK-AIX32

define dso_local i64 @cdtbcd_test(i64 noundef %ll) {
; CHECK-LABEL: cdtbcd_test:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cdtbcd r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
; CHECK-AIX32-LABEL: cdtbcd_test:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    li r3, 0
; CHECK-AIX32-NEXT:    cdtbcd r4, r4
; CHECK-AIX32-NEXT:    blr
entry:
  %conv = trunc i64 %ll to i32
  %0 = tail call i32 @llvm.ppc.cdtbcd(i32 %conv)
  %conv1 = zext i32 %0 to i64
  ret i64 %conv1
}

define dso_local zeroext i32 @cdtbcd_test_ui(i32 noundef zeroext %ui) {
; CHECK-LABEL: cdtbcd_test_ui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cdtbcd r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
; CHECK-AIX32-LABEL: cdtbcd_test_ui:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    cdtbcd r3, r3
; CHECK-AIX32-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.cdtbcd(i32 %ui)
  ret i32 %0
}

define dso_local i64 @cbcdtd_test(i64 noundef %ll) {
; CHECK-LABEL: cbcdtd_test:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cbcdtd r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
; CHECK-AIX32-LABEL: cbcdtd_test:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    li r3, 0
; CHECK-AIX32-NEXT:    cbcdtd r4, r4
; CHECK-AIX32-NEXT:    blr
entry:
  %conv = trunc i64 %ll to i32
  %0 = tail call i32@llvm.ppc.cbcdtd(i32 %conv)
  %conv1 = zext i32 %0 to i64
  ret i64 %conv1
}

define dso_local zeroext i32 @cbcdtd_test_ui(i32 noundef zeroext %ui) {
; CHECK-LABEL: cbcdtd_test_ui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    cbcdtd r3, r3
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
; CHECK-AIX32-LABEL: cbcdtd_test_ui:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    cbcdtd r3, r3
; CHECK-AIX32-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.cbcdtd(i32 %ui)
  ret i32 %0
}

define dso_local i64 @addg6s_test(i64 noundef %ll, i64 noundef %ll2) {
; CHECK-LABEL: addg6s_test:
; CHECK:       bb.0: # %entry
; CHECK-NEXT:    addg6s r3, r3, r4
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
; CHECK-AIX32-LABEL: addg6s_test:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    li r3, 0
; CHECK-AIX32-NEXT:    addg6s r4, r4, r6
; CHECK-AIX32-NEXT:    blr
entry:
  %conv = trunc i64 %ll to i32
  %conv1 = trunc i64 %ll2 to i32
  %0 = tail call i32 @llvm.ppc.addg6s(i32 %conv, i32 %conv1)
  %conv2 = zext i32 %0 to i64
  ret i64 %conv2
}

define dso_local zeroext i32 @addg6s_test_ui(i32 noundef zeroext %ui, i32 noundef zeroext %ui2) {
; CHECK-LABEL: addg6s_test_ui:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addg6s r3, r3, r4
; CHECK-NEXT:    clrldi r3, r3, 32
; CHECK-NEXT:    blr
; CHECK-AIX32-LABEL: addg6s_test_ui:
; CHECK-AIX32:       # %bb.0: # %entry
; CHECK-AIX32-NEXT:    addg6s r3, r3, r4
; CHECK-AIX32-NEXT:    blr
entry:
  %0 = tail call i32 @llvm.ppc.addg6s(i32 %ui, i32 %ui2)
  ret i32 %0
}

declare i32 @llvm.ppc.cdtbcd(i32)
declare i32 @llvm.ppc.cbcdtd(i32)
declare i32 @llvm.ppc.addg6s(i32, i32)
