/**************************************************************************
 **                                                                      **
 ** Copyright (C) 2011-2025 Lukas Spies                                  **
 ** Contact: https://photoqt.org                                         **
 **                                                                      **
 ** This file is part of PhotoQt.                                        **
 **                                                                      **
 ** PhotoQt is free software: you can redistribute it and/or modify      **
 ** it under the terms of the GNU General Public License as published by **
 ** the Free Software Foundation, either version 2 of the License, or    **
 ** (at your option) any later version.                                  **
 **                                                                      **
 ** PhotoQt is distributed in the hope that it will be useful,           **
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of       **
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        **
 ** GNU General Public License for more details.                         **
 **                                                                      **
 ** You should have received a copy of the GNU General Public License    **
 ** along with PhotoQt. If not, see <http://www.gnu.org/licenses/>.      **
 **                                                                      **
 **************************************************************************/
#pragma once

#include <QObject>

class PQCMigrateSettings : public QObject {

    Q_OBJECT

public:
    static void migrate(const QString &oldVersion, const QStringList allVersions);

private:
    static void migrate500();
    static void migrate491();
    static void migrate490();
    static void migrate480();
    static void migrate470();
    static void migrate450();
    static void migrate440();
    static void migrate400();

    static void migrationHelperChangeSettingsName(const QList<QStringList> &mig);
    static QVariant migrationHelperGetOldValue(const QString &table, const QString &setting);
    static void migrationHelperRemoveValue(const QString &table, const QString &setting);
    static void migrationHelperInsertValue(const QString &table, const QString &setting, const QVariantList &value);
    static void migrationHelperSetNewValue(const QString &table, const QString &setting, const QVariant &value);

};
