% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/searchGEO.R
\name{searchGEO}
\alias{searchGEO}
\title{Search GEO database}
\usage{
searchGEO(query, step = 500L)
}
\arguments{
\item{query}{character, the search term. The NCBI uses a search term syntax
which can be associated with a specific search field with square brackets.
So, for instance "Homo sapiens[ORGN]" denotes a search for \verb{Homo sapiens}
in the “Organism” field. Details see
\url{https://www.ncbi.nlm.nih.gov/geo/info/qqtutorial.html}. The names and
definitions of these fields can be identified using
\link{searchFieldsGEO}.}

\item{step}{the number of records to fetch from the database each time. You
may choose a smaller value if failed.}
}
\value{
a data.frame contains the search results
}
\description{
This function searches the \href{https://www.ncbi.nlm.nih.gov/gds}{GDS}
database, and return a data.frame for all the search results.
}
\details{
The NCBI allows users to access more records (10 per second) if they register
for and use an API key. \link[rentrez:set_entrez_key]{set_entrez_key} function
allows users to set this key for all calls to rentrez functions during a
particular R session. You can also set an environment variable \code{ENTREZ_KEY}
by \link[base:Sys.setenv]{Sys.setenv}.  Once this value is set to your key
rentrez will use it for all requests to the NCBI. Details see
\url{https://docs.ropensci.org/rentrez/articles/rentrez_tutorial.html#rate-limiting-and-api-keys}
}
\examples{
\dontrun{
searchGEO("diabetes[ALL] AND Homo sapiens[ORGN] AND GSE[ETYP]")
}

}
\seealso{
\link{searchFieldsGEO}
}
