% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_if_installed.R
\name{check_if_installed}
\alias{check_if_installed}
\title{Checking if needed package is installed}
\usage{
check_if_installed(
  package,
  reason = "for this function to work",
  stop = TRUE,
  minimum_version = NULL,
  quietly = FALSE,
  prompt = interactive(),
  ...
)
}
\arguments{
\item{package}{A character vector naming the package(s), whose installation
needs to be checked in any of the libraries.}

\item{reason}{A phrase describing why the package is needed. The default is a
generic description.}

\item{stop}{Logical that decides whether the function should stop if the
needed package is not installed. Ignored if \code{quietly = TRUE}.}

\item{minimum_version}{A character vector, representing the minimum package
version that is required for each package. Should be of same length as
\code{package}. If \code{NULL}, will automatically check the DESCRIPTION file for
the correct minimum version. If using \code{minimum_version} with more than one
package, \code{NA} should be used instead of \code{NULL} for packages where a
specific version is not necessary.}

\item{quietly}{Logical, if \code{TRUE}, invisibly returns a vector of logicals
(\code{TRUE} for each installed package, \code{FALSE} otherwise), and does not stop
or throw a warning. If \code{quietly = TRUE}, arguments \code{stop} and \code{prompt} are
ignored. Use this argument to internally check for package dependencies
without stopping or warnings.}

\item{prompt}{If \code{TRUE}, will prompt the user to install needed package(s).
Ignored if \code{quietly = TRUE}.}

\item{...}{Currently ignored}
}
\value{
If \code{stop = TRUE}, and \code{package} is not yet installed, the
function stops and throws an error. Else, a named logical vector is
returned, indicating which of the packages are installed, and which not.
}
\description{
Checking if needed package is installed
}
\examples{
\dontshow{if (interactive() || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
\donttest{
check_if_installed("insight")
try(check_if_installed("datawizard", stop = FALSE))
try(check_if_installed("rstanarm", stop = FALSE))
try(check_if_installed("nonexistent_package", stop = FALSE))
try(check_if_installed("insight", minimum_version = "99.8.7"))
try(check_if_installed(c("nonexistent", "also_not_here"), stop = FALSE))
try(check_if_installed(c("datawizard", "rstanarm"), stop = FALSE))
try(check_if_installed(c("datawizard", "rstanarm"),
  minimum_version = c(NA, "2.21.1"), stop = FALSE
))
}
\dontshow{\}) # examplesIf}
}
