//! This crate contains pre-baked ICU4X data, generated by `icu4x-datagen`. The tool
//! fetches locale data from CLDR and transforms them into const code in statics that
//! ICU4X can load, via databake. `lib.rs` in this crate is manually written, but all
//! other code is generated.
//!
//! This crate can be regenerated when there's a new CLDR version, though that is unlikely
//! to result in changes in most cases (currently this only covers list formatting data, which
//! is rather stable). It may need to be regenerated when updating ICU4X versions, especially
//! across major versions, in case it fails to compile after an update.
//!
//! It must be regenerated when adding new locales to Rust, or if Rust's usage of ICU4X
//! grows to need more kinds of data.
//!
//! To regenerate the data, run this command:
//!
//! ```text
//! icu4x-datagen -W --pretty --use-separate-crates \
//! --format baked --locales @en @es @fr @it @ja @pt @ru @tr @zh @zh-Hans @zh-Hant \
//! -m ListAndV1 -o src/data
//! ```

// tidy-alphabetical-start
#![allow(elided_lifetimes_in_paths)]
#![allow(internal_features)]
#![allow(unreachable_pub)] // because this crate is mostly generated code
#![doc(rust_logo)]
#![feature(rustdoc_internals)]
// #![warn(unreachable_pub)] // don't use because this crate is mostly generated code
// tidy-alphabetical-end

pub struct BakedDataProvider;

include!("data/mod.rs");
const _: () = {
    impl_data_provider!(BakedDataProvider);
};

pub const fn baked_data_provider() -> BakedDataProvider {
    BakedDataProvider
}

pub mod supported_locales {
    pub const EN: icu_locale::Locale = icu_locale::locale!("en");
    pub const ES: icu_locale::Locale = icu_locale::locale!("es");
    pub const FR: icu_locale::Locale = icu_locale::locale!("fr");
    pub const IT: icu_locale::Locale = icu_locale::locale!("it");
    pub const JA: icu_locale::Locale = icu_locale::locale!("ja");
    pub const PT: icu_locale::Locale = icu_locale::locale!("pt");
    pub const RU: icu_locale::Locale = icu_locale::locale!("ru");
    pub const TR: icu_locale::Locale = icu_locale::locale!("tr");
    pub const ZH_HANS: icu_locale::Locale = icu_locale::locale!("zh-Hans");
    pub const ZH_HANT: icu_locale::Locale = icu_locale::locale!("zh-Hant");
}
