/*---------------------------------------------------------------------------*\
**$Author: saulius $
**$Date: 2017-11-19 10:57:14 +0200 (Sun, 19 Nov 2017) $ 
**$Revision: 72 $
**$URL: svn://www.crystallography.net/smiles-scripts/trunk/src/net/crystallography/vector/space/ChangeOfBasis.java $
\*---------------------------------------------------------------------------*/

// Compute Cartesian (orthogonal) coordinates in a CDK ICrystal
// object.

package net.crystallography.helpers.cdk;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.ICrystal;

import net.crystallography.vector.space.ChangeOfBasis;

public class OrthogonaliseAtomCoordinates {

    public static void computeOrthogonalCoordinates( ICrystal crystal ) {
        assert crystal != null;

        Matrix3d m = ChangeOfBasis.changeOfBaseMatrix( crystal.getA(),
                                                        crystal.getB(),
                                                       crystal.getC() );

        for( IAtom atom : crystal.atoms() ) {
            Point3d f = atom.getFractionalPoint3d();
            Point3d xyz = ChangeOfBasis.mpMultiply( m, f );
            atom.setPoint3d( xyz );
        }
    }
    
}
